package com.ejie.ab04b.constantes;

import com.ejie.ab04b.util.Utilities;

/**
 * @author GFI-NORTE
 * 
 */
public enum SituacionEntregaEnum {

	NO_SITUACION(36, "00", Constantes.VALUE_INT_NO, null), // NO HAY SITUACION
	ENTREGADO_DOMICILIO(1, "01", Constantes.VALUE_INT_SI, true), // Entregado en
																	// Domicilio
																	// (Final)
	DIRECCION_INCORRECTA(2, "02", Constantes.VALUE_INT_SI, false), // Dirección
																	// Incorrecta.
																	// En
																	// proceso
																	// de
																	// devolución
																	// (Final)
	AUSENTE(3, "03", Constantes.VALUE_INT_NO, null), // Ausente (Seguimiento.
														// Implica aviso)
	DESCONOCIDO(4, "04", Constantes.VALUE_INT_SI, false), // Desconocido. En
															// proceso de
															// devolución
															// (Final)
	FALLECIDO(5, "05", Constantes.VALUE_INT_SI, false), // Fallecido. En proceso
														// de
														// devolución (Final)
	REHUSADO(6, "06", Constantes.VALUE_INT_SI, false), // Rehusado. En proceso
														// de
														// devolución (Final)
	NADIE_HACE_CARGO(7, "07", Constantes.VALUE_INT_SI, false), // Nadie se hace
																// cargo (Final)
	ENTREGADO_OFICINA(8, "08", Constantes.VALUE_INT_SI, true), // Entregado en
																// oficina
																// (Final)
	CADUCADO(9, "09", Constantes.VALUE_INT_SI, false), // Caducado. No retirado
														// en
														// oficina. En proceso
														// de
														// devolución (Final)
	LLEGADA_OFICINA(12, "12", Constantes.VALUE_INT_NO, null), // Llegada a
																// oficina
																// (Seguimiento)
	DEPOSITO_BUZON(23, "13", Constantes.VALUE_INT_NO, null), // 13 Deposito en
																// buzon
	LLEGADA_OFICINA_AVISO(14, "14", Constantes.VALUE_INT_NO, null), // Llegada a
																	// Oficina.
																	// Emitido
																	// aviso
																	// a
																	// destinatario
																	// (Seguimiento)
	AUSENTE_2(15, "15", Constantes.VALUE_INT_NO, null), // Ausente (Seguimiento.
														// Implica aviso)
	ENTREGADO_DESTINO(31, "18", Constantes.VALUE_INT_SI, true), // Entregado en
																// destino
																// (Final)
	OTROS(32, "19", Constantes.VALUE_INT_NO, null), // .
	SOBRANTE(33, "22", Constantes.VALUE_INT_NO, null), // Sobrante (No Retirado
														// de
														// Oficina)
	SOBRANTE_2(25, "23", Constantes.VALUE_INT_NO, null), // Sobrante (No
															// retirado en
															// oficina)
	DEVUELTO_REMITENTE(26, "24", Constantes.VALUE_INT_NO, null), // Devuelto por
																	// orden del
																	// remitente
	DEVUELTO_AGOTA_PLAZO(27, "40", Constantes.VALUE_INT_NO, null), // Devuelto
																	// Agotado
																	// Plazo
	ENTREGADO_ADUANA(28, "66", Constantes.VALUE_INT_NO, null), // Entregado en
																// Aduana
	DEVUELTO_CLIENTE(29, "85", Constantes.VALUE_INT_NO, null), // Devuelto a
																// Cliente. Sin
																// informacion
	AVISADO(30, "90", Constantes.VALUE_INT_NO, null), // Avisado
	EXTRAVIADO(18, "EA", Constantes.VALUE_INT_SI, false), // Extraviado (no se
															// puede
															// justificar la
															// entrega, no
															// aparece)
															// (Final)
	NO_DEPOSITADO(19, "EB", Constantes.VALUE_INT_SI, false), // No ha sido
																// depositado en
																// Correos y
																// Telégrafos.
																// (Final)
	SUSTRACCION(20, "EC", Constantes.VALUE_INT_SI, false), // Sustracción, robo.
															// (Final)
	FUERA_AMBITO(21, "ED", Constantes.VALUE_INT_SI, false), // Envío fuera de
															// ámbito
															// SICER. (Final)
	SIN_INFORMACION(22, "EZ", Constantes.VALUE_INT_NO, false), // Sin
																// Información.
																// Entregado
																// como
																// correo
																// ordinario.
																// Sin PEE
	NO_ENTREGA(34, "XX", Constantes.VALUE_INT_NO, false); // Usuario decide no
															// entregar el sobre
															// a
															// Correos

	private Integer idSituacionEntrega;
	private String codSituacionEntrega;
	private int esFinal;
	private Boolean envioCorrecto;

	/**
	 * Constructor.
	 * 
	 *  idSituacionEntrega
	 *            Integer
	 *  codSituacionEntrega
	 *            String
	 *  esFinal
	 *            int
	 *  envioCorrecto
	 *            Boolean
	 *
	 * @param idSituacionEntrega the id situacion entrega
	 * @param codSituacionEntrega the cod situacion entrega
	 * @param esFinal the es final
	 * @param envioCorrecto the envio correcto
	 */
	private SituacionEntregaEnum(Integer idSituacionEntrega,
			String codSituacionEntrega, int esFinal, Boolean envioCorrecto) {
		this.idSituacionEntrega = idSituacionEntrega;
		this.codSituacionEntrega = codSituacionEntrega;
		this.esFinal = esFinal;
		this.envioCorrecto = envioCorrecto;
	}

	/**
	 * Gets the id situacion entrega.
	 * 
	 *  Integer
	 *
	 * @return the id situacion entrega
	 */
	public Integer getIdSituacionEntrega() {
		return this.idSituacionEntrega;
	}

	/**
	 * Sets the id situacion entrega.
	 * 
	 *  idSituacionEntrega
	 *            Integer
	 *
	 * @param idSituacionEntrega the new id situacion entrega
	 */
	public void setIdSituacionEntrega(Integer idSituacionEntrega) {
		this.idSituacionEntrega = idSituacionEntrega;
	}

	/**
	 * Gets the cod situacion entrega.
	 * 
	 *  String
	 *
	 * @return the cod situacion entrega
	 */
	public String getCodSituacionEntrega() {
		return this.codSituacionEntrega;
	}

	/**
	 * Sets the cod situacion entrega.
	 * 
	 *  codSituacionEntrega
	 *            String
	 *
	 * @param codSituacionEntrega the new cod situacion entrega
	 */
	public void setCodSituacionEntrega(String codSituacionEntrega) {
		this.codSituacionEntrega = codSituacionEntrega;
	}

	/**
	 * Gets the es final.
	 * 
	 *  int
	 *
	 * @return the es final
	 */
	public int getEsFinal() {
		return this.esFinal;
	}

	/**
	 * Sets the es final.
	 * 
	 *  esFinal
	 *            int
	 *
	 * @param esFinal the new es final
	 */
	public void setEsFinal(int esFinal) {
		this.esFinal = esFinal;
	}

	/**
	 * Gets the envio correcto.
	 * 
	 *  Boolean
	 *
	 * @return the envio correcto
	 */
	public Boolean getEnvioCorrecto() {
		return this.envioCorrecto;
	}

	/**
	 * Sets the envio correcto.
	 * 
	 *  envioCorrecto
	 *            Boolean
	 *
	 * @param envioCorrecto the new envio correcto
	 */
	public void setEnvioCorrecto(Boolean envioCorrecto) {
		this.envioCorrecto = envioCorrecto;
	}

	/**
	 * Devuelve true si la situación tiene el flag esFinal marcado a '1'.
	 * 
	 *  boolean
	 *
	 * @return true, if successful
	 */
	public boolean esSituacionFinal() {
		return this.esFinal == Constantes.VALUE_INT_SI.intValue();
	}

	/**
	 * Gets the by id situacion.
	 * 
	 *  idSituacion
	 *            StringInteger
	 *  SituacionEntregaEnum
	 *
	 * @param idSituacion the id situacion
	 * @return the by id situacion
	 */
	public static SituacionEntregaEnum getByIdSituacion(Integer idSituacion) {
		if (idSituacion != null) {
			for (SituacionEntregaEnum sit : SituacionEntregaEnum.values()) {
				if (sit.getIdSituacionEntrega().equals(idSituacion)) {
					return sit;
				}
			}
		}
		return SituacionEntregaEnum.NO_SITUACION;
	}

	/**
	 * Gets the by cod situacion.
	 * 
	 *  codSituacion
	 *            String
	 *  SituacionEntregaEnum
	 *
	 * @param codSituacion the cod situacion
	 * @return the by cod situacion
	 */
	public static SituacionEntregaEnum getByCodSituacion(String codSituacion) {
		if (!Utilities.getInstance().isEmpty(codSituacion)) {
			for (SituacionEntregaEnum sit : SituacionEntregaEnum.values()) {
				if (sit.getCodSituacionEntrega().equals(codSituacion)) {
					return sit;
				}
			}
		}
		return SituacionEntregaEnum.NO_SITUACION;
	}

}
